/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.IConnectionManager;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.QDUtil;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class StdConnectionManager
implements IConnectionManager {
    private List<RemoteInstrument> m_instrList = new ArrayList<RemoteInstrument>();
    private Component m_uiParentComponent;

    public StdConnectionManager(Component component) {
        this.m_uiParentComponent = component;
    }

    public int getInstrumentCount() {
        int n = this.m_instrList.size();
        return n;
    }

    public synchronized RemoteInstrument getInstrument(int n) {
        if (n < 0 || n >= this.m_instrList.size()) {
            return null;
        }
        return this.m_instrList.get(n);
    }

    public synchronized RemoteInstrument getInstrument(String string) {
        for (RemoteInstrument remoteInstrument : this.m_instrList) {
            if (remoteInstrument.getConnection() == null || remoteInstrument.getConnection().getName().compareToIgnoreCase(string) != 0) continue;
            return remoteInstrument;
        }
        return null;
    }

    public synchronized boolean addInstrument(RemoteInstrument remoteInstrument) {
        if (!this.m_instrList.contains(remoteInstrument)) {
            this.m_instrList.add(remoteInstrument);
        }
        return true;
    }

    public synchronized RemoteInstrument newConnection() {
        String string = "";
        if (this.m_instrList.size() == 0) {
            string = this.getAppletServerIP();
        }
        return this.connectTo(string);
    }

    private String getAppletServerIP() {
        String string = "";
        JApplet jApplet = this.m_uiParentComponent instanceof JApplet ? (JApplet)this.m_uiParentComponent : (JApplet)SwingUtilities.getAncestorOfClass(JApplet.class, this.m_uiParentComponent);
        if (jApplet != null) {
            try {
                URL uRL = jApplet.getCodeBase();
                string = uRL.getHost();
            }
            catch (NullPointerException nullPointerException) {
                string = "";
            }
        }
        return string;
    }

    private RemoteInstrument connectTo(String string) {
        RemoteInstrument remoteInstrument;
        if (string.length() == 0) {
            string = QDUtil.getInstrumentIP(this.m_uiParentComponent);
        }
        if ((remoteInstrument = this.getInstrument(string)) == null) {
            SocketConnection socketConnection = new SocketConnection(string);
            remoteInstrument = new RemoteInstrument(socketConnection, null);
            this.m_instrList.add(remoteInstrument);
        }
        return remoteInstrument;
    }

    public RemoteInstrument getAppletInstrument() {
        String string = this.getAppletServerIP();
        if (string.length() == 0) {
            return null;
        }
        RemoteInstrument remoteInstrument = this.connectTo(string);
        if (remoteInstrument != null && !remoteInstrument.isConnected()) {
            try {
                remoteInstrument.connect();
            }
            catch (InstrumentException instrumentException) {
                return null;
            }
        }
        return remoteInstrument;
    }

    public RemoteInstrument getDefaultInstrument() {
        RemoteInstrument remoteInstrument = null;
        remoteInstrument = this.getInstrumentCount() == 0 ? this.newConnection() : this.getInstrument(0);
        if (!remoteInstrument.isConnected()) {
            try {
                remoteInstrument.connect();
            }
            catch (InstrumentException instrumentException) {
                return null;
            }
        }
        return remoteInstrument;
    }

    public synchronized void removeAllInstruments() {
        for (RemoteInstrument remoteInstrument : this.m_instrList) {
            remoteInstrument.disconnect();
        }
        this.m_instrList.clear();
    }
}

